<?php
/* --------------------------------------------------------------
   ShopConfigApiRequestValidator.php 2024-05-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2024 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Api\Modules\ShopConfig\App;

class ShopConfigApiRequestValidator
{
    private const KEY_PARAM_NAME = "key";
    private const CONFIG_PREFIX  = "configuration/";
    
    
    public function validateGetParams(array $params): array
    {
        $errors = [];
        if (!array_key_exists(self::KEY_PARAM_NAME, $params)) {
            $errors[] = 'Param "' . self::KEY_PARAM_NAME . '" is missing.';
        } else {
            $allowedKeys = $this->getAllowedConfigKeys();
            $key         = $params[self::KEY_PARAM_NAME];
            
            if (!is_string($key)) {
                $errors[] = 'Param "' . self::KEY_PARAM_NAME . '" must be of type string.';
            } elseif (!in_array($key, $allowedKeys)) {
                $errors[] = 'Key "' . $key . '" not found. Available keys: "' . join('", "', $allowedKeys) . '"';
            }
        }
        
        return $errors;
    }
    
    
    public function getAllowedConfigKeys(): array
    {
        return [
            'DEFAULT_SHIPPING_STATUS_ID',
            'DEFAULT_LANGUAGE',
            'DEFAULT_CURRENCY',
            'DEFAULT_CUSTOMERS_STATUS_ID',
            'GROUP_CHECK',
            'STOCK_CHECK',
            'STOCK_ALLOW_CHECKOUT',
        ];
    }
    
    
    public function getKeyParamName(): string
    {
        return self::KEY_PARAM_NAME;
    }
    
    
    public function getConfigPrefix(): string
    {
        return self::CONFIG_PREFIX;
    }
}